/****************************************************************************
*
*    Copyright (c) 2005 - 2014 by Vivante Corp.  All rights reserved.
*
*    The material in this file is confidential and contains trade secrets
*    of Vivante Corporation. This is proprietary information owned by
*    Vivante Corporation. No part of this work may be disclosed,
*    reproduced, copied, transmitted, or used in any way for any purpose,
*    without the express written permission of Vivante Corporation.
*
*****************************************************************************/


#ifndef _tiny_ui_hw_h
#define _tiny_ui_hw_h

#define TINY_UI_HW_CLOCK_CONTROL    0x000
#define TINY_UI_HW_IDLE             0x004
#define TINY_UI_INTR_STATUS         0x010
#define TINY_UI_INTR_ENABLE         0x014
#define TINY_UI_HW_CHIP_ID          0x020
#define TINY_UI_HW_FEATURES         0x0A0
#define TINY_UI_HW_CMDBUF_ADDRESS   0x500
#define TINY_UI_HW_CMDBUF_SIZE      0x504

typedef struct tiny_ui_hw_clock_control {
    uint32_t reserved0 : 1;
    uint32_t clock_gate : 1;
    uint32_t scale : 7;
    uint32_t scale_load : 1;
    uint32_t reserved10 : 2;
    uint32_t soft_reset : 1;
    uint32_t reserved13 : 6;
    uint32_t isolate : 1;
} tiny_ui_hw_clock_control_t;

#define TINY_UI_HW_IDLE_STATE       0x0B05
#define TINY_UI_HW_FEATURE_UI       0x0040

#endif /* defined(_tiny_ui_hw_h) */
